import { _decorator, Component, Node } from 'cc';

const {ccclass, property} = _decorator;

@ccclass('Wall')
export class Wall extends Component {

    @property(Node) top: Node = null;

    @property(Node) bottom: Node = null;

    @property isInit = false;

    start() {
        if (!this.isInit) {
            const dH = Math.random() * 2 + 2;
            this.top.setPosition(0, dH / 2, 0);
            this.bottom.setPosition(0, -dH / 2, 0);
        }
    }

    get topY() {
        return this.top.position.y + this.node.position.y;
    }

}

