import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { changeScene, showToast } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import GameMgr from "../GameMgr";
import store from "../../store/store";
import { MainGame } from "../Scenes/MainGame/MainGame";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass('NoPrizePanel')
export default class NoPrizePanel extends Panel {

    static skin = "NoPrizePanel";
    static group = "NoPrizePanel";

    @property(Node)
    close: Node = null!;

    @property(Node)
    again: Node = null!;

    async start() {

        sendLog(LOG_TYPE.EXPOSURE, 5);

        this.close.on(Button.EventType.CLICK, this.onClose, this);
        this.again.on(Button.EventType.CLICK, this.clickAgain, this);
    }

    /**
     * 返回首页
     */
    onClose = () => {
        changeScene(HomeScene);
        this.hidePanel();
    }

    clickAgain = async () => {

        sendLog(LOG_TYPE.CLICK, 5);

        this.hidePanel();
        if (store.homeInfo.leftTimes <= 0) {
            changeScene(HomeScene);
            showToast("没次数啦，明天再来吧！");
        } else {
            await GameMgr.ins.start();
            changeScene(MainGame);
        }
    }

}
