import { sendWebNet, sendWebNetWithToken, WebNetName } from "./Utils/WebNet/WebNet";
import { hideWaiting, showWaiting } from "db://assets/Module/UIFast";
import { AESDecrypt, AESEncrypt } from "./Utils/Crypto";
import store from "../store/store";

// const en = AESEncrypt(JSON.stringify({
//     recordId: 232323,
//     oneGameHammerQuantity: 99,
//     oneGameProteanQuantity: 99,
// }), "FDF817451A60EB8F", "cDOiBC1n2QrkAY2P");
//
// console.log(en);

export default class GameMgr {

    private static _ins: GameMgr = null;

    public static get ins() {
        !GameMgr._ins && (GameMgr._ins = new GameMgr());
        return GameMgr._ins;
    }

    gameInfo: {
        recordId: number,
        oneGameHammerQuantity: number,
        oneGameProteanQuantity: number,
    } = {
        recordId: 0,
        oneGameHammerQuantity: 0,
        oneGameProteanQuantity: 0,
    };

    /**
     * 开始游戏
     */
    async start() {
        const {success, data} = await sendWebNetWithToken(WebNetName.start);
        store.updateIndex();
        if (!success) {
            return false;
        }

        const decrypt = JSON.parse(AESDecrypt(data, "FDF817451A60EB8F", "cDOiBC1n2QrkAY2P"));

        const {recordId, oneGameHammerQuantity, oneGameProteanQuantity} = decrypt;

        this.gameInfo = {
            recordId,
            oneGameHammerQuantity,
            oneGameProteanQuantity,
        }

        return true;
    }

    /**
     * 提交游戏结果
     */
    async submit(
        suc: boolean,
        useHammerQuantity: number,
        useProteanQuantity: number
    ) {

        showWaiting();

        const params = {
            recordId: this.gameInfo.recordId,
            useHammerQuantity,
            useProteanQuantity,
            success: suc,
            timestamp: Date.now(),
        }

        const encrypt = AESEncrypt(JSON.stringify(params), "FDF817451A60EB8F", "cDOiBC1n2QrkAY2P");

        const res = await sendWebNetWithToken(WebNetName.submit, {
            param: encrypt,
        }, null, false);

        hideWaiting();

        // if (!success) {
        //     changeScene(HomeScene);
        //     return false;
        // }
        //
        // if (!data?.prize || data.prize.optionId == "thanks") {
        //
        // } else {
        //
        // }

        return res;

    }

}
