import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite } from "cc";
import { changeScene, showToast } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import { strFormat } from "../Utils/Utils";
import { PrizeScene } from "../Scenes/PrizeScene/PrizeScene";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";
import store from "../../store/store";
import GameMgr from "../GameMgr";
import { MainGame } from "../Scenes/MainGame/MainGame";

const {ccclass, property} = _decorator;

@ccclass('FailPrizePanel2')
export default class FailPrizePanel2 extends Panel {

    static skin = "FailPrizePanel2";
    static group = "FailPrizePanel2";

    @property(Node)
    close: Node = null!;

    @property(Node)
    again: Node = null!;

    async start() {

        sendLog(LOG_TYPE.EXPOSURE, 5);

        this.close.on(Button.EventType.CLICK, this.onClose, this);
        this.again.on(Button.EventType.CLICK, this.clickAgain, this);
    }

    clickAgain = async () => {

        sendLog(LOG_TYPE.CLICK, 5);

        this.hidePanel();
        if (store.homeInfo.leftTimes <= 0) {
            changeScene(HomeScene);
            showToast("没次数啦，明天再来吧！");
        } else {
            await GameMgr.ins.start();
            changeScene(MainGame);
        }
    }
    /**
     * 返回首页
     */
    onClose = () => {
        changeScene(HomeScene);
        this.hidePanel();
    }

}
