import mobx from "mobx";
import { sendWebNet, WebNetName } from "db://assets/Scripts/Utils/WebNet/WebNet";

const {makeAutoObservable} = mobx;


export interface IHomeInfo {
    actStartTimestamp: number;
    actEndTimestamp: number;
    currentTimestamp: number;
    addDailyFreeTimes: number;
    leftTimes: number;
    newGuideFlag: number;
}


class Store {
    frontVariable: { [key in string]: any } = {}

    async updateFrontVariable() {
        const {success, data} = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        this.frontVariable = data;
    }

    homeInfo: IHomeInfo = {
        actStartTimestamp: 0,   // 活动开始时间戳（精确到毫秒）
        actEndTimestamp: 0,     // 活动结束时间戳（精确到毫秒）
        currentTimestamp: 0,    // 当前时间戳（精确到毫秒）
        addDailyFreeTimes: 0,   // 本次访问新增每日免费游戏次数（为null或0表示本次访问没有新增）
        leftTimes: 99999,           // 剩余游戏次数 本活动不限制次数，所以默认值很大
        newGuideFlag: 0,        // 新手引导标记（0-未引导，1-已引导）
    }

    async updateIndex() {
        const {success, data} = await sendWebNet(WebNetName.index);
        if (!success) {
            return;
        }
        this.homeInfo = data;
    }

    ruleInfo: string = "";
    async updateRule() {
        const {success, data} = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

}

const store: Store = makeAutoObservable(new Store());

export default store;