import Panel from "../../Module/Panel";
import { _decorator, Button, RichText, UITransform, Node } from "cc";
import store from "../../store/store";
import { observer, render } from "../../store/decorators";

const {ccclass, property} = _decorator;

@observer
@ccclass('RulePanel')
export default class RulePanel extends Panel {

    static skin = "RulePanel";
    static group = "RulePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) ruleNode: Node = null;
    @property(Node) content: Node = null;

    async start() {

        store.updateRule();

        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
    }

    clickClose = () => {
        this.hidePanel();
    }

    @render
    render() {
        const {ruleInfo = ""} = store;
        this.setRuleTxt(ruleInfo);
    }

    setRuleTxt(txt) {
        const ruleTxt = this.ruleNode.getComponent(RichText);
        ruleTxt.maxWidth = this.content.getComponent(UITransform).width;

        // this.scheduleOnce(() => {
        ruleTxt.string = txt
            .replace(/<p\b.*?(?:\>|\/>)/gi, "")
            .replace(/<\/p\>/gi, "<br/>")
            .replace(/<strong>/gi, "<b>")
            .replace(/<\/strong>/gi, "</b>");
        this.content.getComponent(UITransform).height = this.ruleNode.getComponent(UITransform).height;
        // }, 0.166);
    }

}
