import Panel from "../../Module/Panel";
import { _decorator, Node } from "cc";
import Svga from "../../Component/Svga/Svga";
import GameMgr from "../GameMgr";
import { changeScene, showPanel } from "../../Module/UIFast";
import { HomeScene } from "../Scenes/HomeScene";
import PrizePanel from "./PrizePanel";
import NoPrizePanel from "./NoPrizePanel";

const {ccclass, property} = _decorator;

@ccclass('MergeMaxPanel')
export default class MergeMaxPanel extends Panel {

    static bundle: string = "";
    static skin = "MergeMaxPanel";
    static group = "MergeMaxPanel";

    @property(Node)
    svga: Node = null;

    submitPromise = null;

    async start() {
        this.svga.on(Svga.EventType.END_FRAME, this.svgaEnd, this);

        // this.submitPromise = GameMgr.ins.submit(
        //     true,
        //     this.data.useHammerQuantity,
        //     this.data.useProteanQuantity
        // );
    }

    svgaEnd = async () => {
        const {success, data} = await this.data.submitPromise;
        this.hidePanel();

        if (!success || !data?.prize || data.prize.prizeId == "thanks") {
            showPanel(NoPrizePanel);
        } else {
            showPanel(PrizePanel, data.prize);
        }

    }

}
