import {
    _decorator, Collider2D, Contact2DType, EPhysics2DDrawFlags,
    EventTouch,
    input,
    Input, IPhysics2DContact,
    PhysicsSystem2D,
    v3,
} from "cc";
import Scene from "db://assets/Module/Scene";

const {ccclass, property} = _decorator;

@ccclass("MainGame")
export class MainGame extends Scene {
    static bundle: string = "MainGame";
    static skin: string = "MainGame";
    static group: string[] = ["MainGame"];

    onLoad() {
        PhysicsSystem2D.instance.enable = true;
        // PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Aabb |
        //     EPhysics2DDrawFlags.Pair |
        //     EPhysics2DDrawFlags.CenterOfMass |
        //     EPhysics2DDrawFlags.Joint |
        //     EPhysics2DDrawFlags.Shape;

        input.on(Input.EventType.TOUCH_START, this.onTouchStart, this);
        input.on(Input.EventType.TOUCH_MOVE, this.onTouchMove, this);
        input.on(Input.EventType.TOUCH_END, this.onTouchEC, this);
        input.on(Input.EventType.TOUCH_CANCEL, this.onTouchEC, this);

        PhysicsSystem2D.instance.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
        PhysicsSystem2D.instance.on(Contact2DType.END_CONTACT, this.onEndContact, this);
        PhysicsSystem2D.instance.on(Contact2DType.PRE_SOLVE, this.onPreSolve, this);
        PhysicsSystem2D.instance.on(Contact2DType.POST_SOLVE, this.onPostSolve, this);

    }

    async start() {

    }

    onBeginContact(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体开始接触时被调用一次
        console.log('onBeginContact', selfCollider, otherCollider);
        if (selfCollider.node.name === otherCollider.node.name) {

        }
    }

    onEndContact(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体结束接触时被调用一次
    }

    onPreSolve(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 每次将要处理碰撞体接触逻辑时被调用
    }

    onPostSolve(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 每次处理完碰撞体接触逻辑时被调用
    }

    onTouchStart = (e: EventTouch) => {

    };

    onTouchMove = (e: EventTouch) => {

    };

    onTouchEC = (e: EventTouch) => {

    };

    update(deltaTime: number) {

    }
}
