import { _decorator, Button, Label, Node } from 'cc';
import Scene from "db://assets/Module/Scene";
import { getWebData, LOG_TYPE, sendLog, WebNetName } from "db://assets/Scripts/Utils/WebNet/WebNet";
import { MainGame } from "./MainGame/MainGame";
import { changeScene, showPanel, showToast } from "db://assets/Module/UIFast";
import GameMgr from "db://assets/Scripts/GameMgr";
import RulePanel from '../Panels/RulePanel';
import store from "../../store/store";
import { observer, render } from "../../store/decorators";

const {ccclass, property} = _decorator;

@observer
@ccclass('HomeScene')
export class HomeScene extends Scene {

    static skin: string = "HomeScene";
    static group: string[] = ["HomeScene"];

    /** 去挑战按钮 */
    @property(Node)
    startBtn: Node = null;

    /** 任务按钮 */
    @property(Node)
    taskBtn: Node = null;

    @property(Node)
    shareBtn: Node = null;

    /** 规则按钮 */
    @property(Node)
    ruleBtn: Node = null;

    /** 剩余次数 */
    @property(Label)
    gameCountLabel: Label = null;

    onLoad() {
        this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
        this.taskBtn.on(Button.EventType.CLICK, this.clickTask, this);
        this.shareBtn.on(Button.EventType.CLICK, this.clickShare, this);
        this.ruleBtn.on(Button.EventType.CLICK, this.clickRule, this);
    }

    async start() {
        store.getBaseInfo();
        store.updateIndex();
    }

    @render
    render() {
        const {
            remainGameTime = 0, // 剩余挑战次数
        } = store.homeInfo || {};

        this.gameCountLabel.string = `游戏剩余次数：${remainGameTime}`;

    }

    /** 校验活动状态 */
    checkActStatus = () => {
        const {timeStamp} = getWebData(WebNetName.index) || {};
        const {activityStartTime, activityEndTime} = store.homeInfo || {};
        if (activityStartTime > timeStamp) {
            showToast("活动暂未开始，敬请期待~");
            return false;
        } else if (activityEndTime <= timeStamp) {
            showToast("活动已结束~");
            return false;
        }
        return true;
    }

    /** 去挑战 */
    clickStart = async () => {
        sendLog(LOG_TYPE.CLICK, 5)
        if (!this.checkActStatus()) return false;
        const {
            remainGameTime = 0, // 剩余挑战次数
            boolDayPlayLimit,   // 今日挑战是否已达上限 true:是 false:不是
        } = store.homeInfo || {};

        if (boolDayPlayLimit) {
            return showToast("今日挑战已达上限，明天再来吧～");
        }
        if (!remainGameTime) {
            return showToast("没有次数啦～快去做任务吧！\n明日再来还有免费次数哦！");
        }

        this.btnEnable(this.startBtn, false);
        try {
            const success = await GameMgr.ins.start();
            if (success) {
                await changeScene(MainGame);
            }
        } catch (e) {
            console.error(e);
        }
        this.btnEnable(this.startBtn, true);
    }

    /** 任务 */
    clickTask = async () => {
        sendLog(LOG_TYPE.CLICK, 7)
        if (!this.checkActStatus()) return false
    }

    /** 规则 */
    clickRule = async () => {
        sendLog(LOG_TYPE.CLICK, 11)
        showPanel(RulePanel);
    }

    /** 返回 */
    clickShare = async () => {
        sendLog(LOG_TYPE.CLICK, 10)
        if (!this.checkActStatus()) return false;
    }

}

