import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite } from "cc";
import { changeScene } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import { SHARE_TYPE } from "../const";
import { strFormat } from "../Utils/Utils";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass('PrizePanel')
export default class PrizePanel extends Panel {

    static bundle: string = "";
    static skin = "PrizePanel";
    static group = "PrizePanel";

    @property(Node)
    close: Node = null!;

    @property(Node)
    get: Node = null!;

    @property(Node)
    share: Node = null!;

    @property(Label)
    score: Label = null!;

    @property(Label)
    prizeName: Label = null!;

    @property(Sprite)
    img: Sprite = null!;

    async start() {
        sendLog(LOG_TYPE.EXPOSURE,19)
        this.close.on(Button.EventType.CLICK, this.onClose, this);
        this.get.on(Button.EventType.CLICK, this.onClose, this);
        this.share.on(Button.EventType.CLICK, this.onShare, this);

        const {prizeName, prizeImg, score} = this.data;

        this.score.string = `本次游园币：${score}`;
        this.prizeName.string = strFormat(
            prizeName,
            20
        );

        this.img.spriteFrame = prizeImg;
    }

    /**
     * 返回首页
     */
    onClose = () => {
        changeScene(HomeScene);
        this.hidePanel();
    }

    onShare = () => {
        // 去炫耀 分享
    }

}
