import { _decorator, Button, Component, Node } from 'cc';
import Scene from "../../Module/Scene";
import { changeScene } from "../../Module/UIFast";
import { MainGame } from "./MainGame/MainGame";
import GameMgr from "../GameMgr";
import { _asyncThrottle } from "../Utils/Utils";

const {ccclass, property} = _decorator;

@ccclass('GuideScene')
export class GuideScene extends Scene {

    static skin: string = "GuideScene";
    static group: string[] = ["GuideScene"];

    @property({type: [Node]}) guideNode: Node[] = [];
    @property({type: Node}) nextBtn: Node = null;
    @property({type: Node}) startBtn: Node = null;

    private _guideIndex = 0;
    get guideIndex() {
        return this._guideIndex;
    }

    set guideIndex(value: number) {
        this._guideIndex = value;
        this.guideNode.forEach((node, index) => {
            node.active = index == value;
        });

        const isLastStep = value == this.guideNode.length - 1;
        this.startBtn.active = isLastStep;
        this.nextBtn.active = !isLastStep;
    }

    onLoad() {
        this.nextBtn.on(Button.EventType.CLICK, this.clickNext, this);
        this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
    }

    clickNext() {
        this.guideIndex++;
    }

    clickStart = _asyncThrottle(async () => {
        await GameMgr.ins.start();
        await changeScene(MainGame);
    })
}


