import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite } from "cc";
import { changeScene } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import { strFormat } from "../Utils/Utils";

const {ccclass, property} = _decorator;

@ccclass('PrizePanel')
export default class PrizePanel extends Panel {

    static skin = "PrizePanel";
    static group = "PrizePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) againBtn: Node = null;
    @property(Node) viewBtn: Node = null;
    @property(Node) rankBtn: Node = null;
    @property(Label) scoreLabel: Label = null;
    @property(Label) highestLabel: Label = null;


    @property(Label) prizeName: Label = null;

    @property(Sprite) img: Sprite = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.onClose, this);
        this.viewBtn.on(Button.EventType.CLICK, this.clickView, this);
        this.againBtn.on(Button.EventType.CLICK, this.clickAgain, this);
        this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
    }

    async start() {

        const {optionName, optionImg} = this.data;

        this.prizeName.string = strFormat(optionName, 20);

        this.img.spriteFrame = optionImg;
    }

    clickView = () => {
        this.hidePanel();
    }

    clickAgain = () => {
        this.hidePanel();
        changeScene(HomeScene);
    }

    clickRank = () => {
        this.hidePanel();
        changeScene(HomeScene);
    }

    onClose = () => {
        changeScene(HomeScene);
        this.hidePanel();
    }

}
