import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node } from "cc";
import { changeScene, showToast } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import GameMgr from "../GameMgr";
import store from "../store/store";
import { MainGame } from "../Scenes/MainGame/MainGame";

const {ccclass, property} = _decorator;

@ccclass('NoPrizePanel')
export default class NoPrizePanel extends Panel {

    static skin = "NoPrizePanel";
    static group = "NoPrizePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) againBtn: Node = null;
    @property(Node) rankBtn: Node = null;
    @property(Label) scoreLabel: Label = null;
    @property(Label) highestLabel: Label = null;


    async start() {

        this.closeBtn.on(Button.EventType.CLICK, this.onClose, this);
        this.againBtn.on(Button.EventType.CLICK, this.clickAgain, this);
        this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
    }

    clickRank = () => {
        this.hidePanel();
        changeScene(HomeScene);
    }

    onClose = () => {
        changeScene(HomeScene);
        this.hidePanel();
    }

    clickAgain = async () => {

        this.hidePanel();
        if (store.homeInfo.leftTimes <= 0) {
            changeScene(HomeScene);
            showToast("没次数啦，明天再来吧！");
        } else {
            await GameMgr.ins.start();
            changeScene(MainGame);
        }
    }

}
