import mobx from "mobx";
import { sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";

const {makeAutoObservable} = mobx;


export interface IHomeInfo {
    activityRule: string;
    alreadyGuideSteps: number;
    allGuideSteps: number;
}


class Store {
    frontVariable: { [key in string]: any } = {}

    async updateFrontVariable() {
        const {success, data} = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        this.frontVariable = data;
    }

    homeInfo: IHomeInfo = {
        activityRule: "",
        alreadyGuideSteps: 0,     // 活动结束时间戳（精确到毫秒）
        allGuideSteps: 0,    // 当前时间戳（精确到毫秒）
    }

    async updateIndex() {
        const {success, data} = await sendWebNet(
            WebNetName.index,
            {gameType: 2}
        );
        if (!success) {
            return;
        }

        this.homeInfo = data;
    }

    ruleInfo: string = "";

    async updateRule() {
        const {success, data} = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

}

const store: Store = makeAutoObservable(new Store());

export default store;