import { BuildPlugin } from '../@types';

export const load: BuildPlugin.load = function() {
    console.debug(`${PACKAGE_NAME} load`);
};

export const unload: BuildPlugin.load = function() {
    console.debug(`${PACKAGE_NAME} unload`);
};

const PACKAGE_NAME = 'duiba-publish';

export const configs: BuildPlugin.Configs = {
    'web-mobile': {
        hooks: './hooks',
        doc: 'editor/publish/custom-build-plugin.html',
        options: {
            uploadDir: {
                label: '上传文件夹',
                description: '要上传到哪个子文件夹',
                default: 'template3d',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'template3d',
                    },
                },
                verifyRules: ['required']
            },
            region: {
                label: 'region',
                description: 'region',
                default: 'oss-cn-hangzhou',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'region',
                    },
                },
                verifyRules: ['required']
            },
            bucket: {
                label: 'bucket',
                description: 'bucket',
                default: 'duiba-credits-test',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'bucket',
                    },
                },
                verifyRules: ['required']
            },
            accessKeyId: {
                label: 'accessKeyId',
                description: 'accessKeyId',
                default: 'LTAI5tFiyBroYqzgu6d6E3Sz',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        password: true,
                        placeholder: 'accessKeyId',
                    },
                },
                verifyRules: ['required']
            },
            accessKeySecret: {
                label: 'accessKeySecret',
                description: 'accessKeySecret',
                default: 'aEpPaVnxnicK6iwzcJTUpzGhCghSt0',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        password: true,
                        placeholder: 'accessKeySecret',
                    },
                },
                verifyRules: ['required']
            },
        },
    },
};
