import { sendWebNet, WebNetName } from "./Utils/WebNet/WebNet";
import { changeScene, hideWaiting, showPanel, showToast, showWaiting } from "db://assets/Module/UIFast";
import { AESDecrypt, AESEncrypt } from "./Utils/Crypto";
import store from "./store/store";
import { HomeScene } from "./Scenes/HomeScene";
import NoPrizePanel from "./Panels/NoPrizePanel";
import PrizePanel from "./Panels/PrizePanel";
import ErrorPanel from "./Panels/ErrorPanel";

export default class GameMgr {

    private static _ins: GameMgr = null;

    public static get ins() {
        !GameMgr._ins && (GameMgr._ins = new GameMgr());
        return GameMgr._ins;
    }

    gameInfo: {
        recordId: number,
    } = {
        recordId: 0,
    };

    /**
     * 开始游戏
     */
    async start() {
        showWaiting();
        const { success, data, code } = await sendWebNet(WebNetName.start, {
            entryTokenId: store.miniAppQuery.entryTokenId,
        }, { hideMsg: true });
        hideWaiting();

        store.updateIndex();
        if (!success) {
            showPanel(ErrorPanel, { code: code });
            return false;
        }

        const decrypt = JSON.parse(AESDecrypt(data, "FDF817451A60EB6F", "cDOiBC1n2QrkAY2P"));

        const { recordId } = decrypt;

        this.gameInfo = {
            recordId,
        }

        return true;
    }

    /**
     * 提交游戏结果
     */
    async submit(score: number) {

        showWaiting();

        const params = {
            recordId: this.gameInfo.recordId,
            score: score,
            level: 1,
            timestamp: Date.now(),
        }

        const encrypt = AESEncrypt(JSON.stringify(params), "FDF817451A60EB6F", "cDOiBC1n2QrkAY2P");

        const { success, data } = await sendWebNet(WebNetName.submit, {
            encryptedData: encrypt,
        }, {
            // isGet: false,
        });

        hideWaiting();

        if (!success) {
            changeScene(HomeScene);
            return false;
        }

        if (data.thirdCode && +data.thirdCode != 10000) {
            if (+data.thirdCode == 10001) {
                showPanel(NoPrizePanel, {
                    highest: data?.historyMaxScore || 0,
                    score,
                    errorMsg: "Too many players now.\n" +
                        "Please come back later to check if\n" +
                        "you’ve won.",
                });
            } else if (+data.thirdCode == 10002) {
                showPanel(NoPrizePanel, {
                    highest: data?.historyMaxScore || 0,
                    score,
                    errorMsg: "Service currently unavailable.\n" +
                        "Please come back later to check if\n" +
                        "you’ve won.",
                });
            } else {
                showToast(data.thirdMsg);
                changeScene(HomeScene);
            }
        } else {
            const panelData = {
                prizeVO: data?.prizeVO,
                highest: data?.historyMaxScore || 0,
                score,
            }
            if (data?.prizeVO) {
                showPanel(PrizePanel, panelData);
            } else {
                showPanel(NoPrizePanel, panelData);
            }
        }

    }

}
