"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configs = exports.unload = exports.load = void 0;
const load = function () {
    console.debug(`${PACKAGE_NAME} load`);
};
exports.load = load;
const unload = function () {
    console.debug(`${PACKAGE_NAME} unload`);
};
exports.unload = unload;
const PACKAGE_NAME = 'duiba-publish';
exports.configs = {
    'web-mobile': {
        hooks: './hooks',
        doc: 'editor/publish/custom-build-plugin.html',
        options: {
            uploadDir: {
                label: '上传文件夹',
                description: '要上传到哪个子文件夹',
                default: 'template3d',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'template3d',
                    },
                },
                verifyRules: ['required']
            },
            region: {
                label: 'region',
                description: 'region',
                default: 'oss-cn-hangzhou',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'region',
                    },
                },
                verifyRules: ['required']
            },
            bucket: {
                label: 'bucket',
                description: 'bucket',
                default: 'duiba-credits-test',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'bucket',
                    },
                },
                verifyRules: ['required']
            },
            accessKeyId: {
                label: 'accessKeyId',
                description: 'accessKeyId',
                default: 'LTAI5tFiyBroYqzgu6d6E3Sz',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        password: true,
                        placeholder: 'accessKeyId',
                    },
                },
                verifyRules: ['required']
            },
            accessKeySecret: {
                label: 'accessKeySecret',
                description: 'accessKeySecret',
                default: 'aEpPaVnxnicK6iwzcJTUpzGhCghSt0',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        password: true,
                        placeholder: 'accessKeySecret',
                    },
                },
                verifyRules: ['required']
            },
        },
    },
};
