import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node } from "cc";
import { changeScene, showPanel, showToast } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import RankPanel from "./RankPanel";
import { popWindow } from "../AppTool";

const {ccclass, property} = _decorator;

@ccclass('NoPrizePanel')
export default class NoPrizePanel extends Panel {

    static skin = "NoPrizePanel";
    static group = "NoPrizePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) againBtn: Node = null;
    @property(Node) rankBtn: Node = null;
    @property(Label) scoreLabel: Label = null;
    @property(Label) highestLabel: Label = null;

    @property(Node) box: Node = null;
    @property(Node) errorTip: Node = null;


    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.onClose, this);
        this.againBtn.on(Button.EventType.CLICK, this.clickAgain, this);
        this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
    }

    async start() {
        const {highest, score, isError} = this.data;

        this.highestLabel.string = highest;
        this.scoreLabel.string = score;

        this.box.active = !isError;
        this.errorTip.active = isError;
    }

    clickRank = () => {
        this.hidePanel();
        changeScene(HomeScene);
        showPanel(RankPanel);
    }

    onClose = () => {
        this.hidePanel();
        changeScene(HomeScene);
        // popWindow();
    }

    clickAgain = async () => {
        // this.hidePanel();
        popWindow();

        // const success = await GameMgr.ins.start();
        // if (!success) {
        //     changeScene(HomeScene);
        //     return;
        // }
        // changeScene(MainGame);

    }

}
