import Panel from "../../Module/Panel";
import { _decorator, Button, Node, Sprite, SpriteFrame } from "cc";
import { observer } from "../store/decorators";

const { ccclass, property } = _decorator;

@observer
@ccclass('ErrorPanel')
export default class ErrorPanel extends Panel {

    static bundle: string = "ErrorPanel";
    static skin = "ErrorPanel";
    // static group = "ErrorPanel";

    @property(Node) ok: Node = null;
    @property(Sprite) tip: Sprite = null;

    @property(SpriteFrame) gameUnavailable: SpriteFrame = null;
    @property(SpriteFrame) networkError: SpriteFrame = null;
    @property(SpriteFrame) systemBusy: SpriteFrame = null;


    onLoad() {
        this.ok.on(Button.EventType.CLICK, this.clickOK);
    }

    protected start() {
        this.tip.spriteFrame = {
            400001: this.gameUnavailable,
            400002: this.gameUnavailable,
            400003: this.systemBusy,
            100013: this.networkError,
        }[this.data.code] || this.networkError;
    }

    clickOK = () => {
        this.hidePanel();
    }

}
