import { sendWebNet, WebNetName } from "./Utils/WebNet/WebNet";
import { changeScene, hideWaiting, showPanel, showWaiting } from "db://assets/Module/UIFast";
import { AESDecrypt, AESEncrypt } from "./Utils/Crypto";
import store from "./store/store";
import { HomeScene } from "./Scenes/HomeScene";
import NoPrizePanel from "./Panels/NoPrizePanel";
import PrizePanel from "./Panels/PrizePanel";

export default class GameMgr {

    private static _ins: GameMgr = null;

    public static get ins() {
        !GameMgr._ins && (GameMgr._ins = new GameMgr());
        return GameMgr._ins;
    }

    gameInfo: {
        recordId: number,
    } = {
        recordId: 0,
    };

    /**
     * 开始游戏
     */
    async start() {
        showWaiting();
        const {success, data} = await sendWebNet(WebNetName.start);
        hideWaiting();

        store.updateIndex();
        if (!success) {
            return false;
        }

        const decrypt = JSON.parse(AESDecrypt(data, "FDF817451A60EB6F", "cDOiBC1n2QrkAY2P"));

        const {recordId} = decrypt;

        this.gameInfo = {
            recordId,
        }

        return true;
    }

    /**
     * 提交游戏结果
     */
    async submit(score: number) {

        showWaiting();

        const params = {
            recordId: this.gameInfo.recordId,
            score: score,
            level: 1,
            timestamp: Date.now(),
        }

        const encrypt = AESEncrypt(JSON.stringify(params), "FDF817451A60EB6F", "cDOiBC1n2QrkAY2P");

        const {success, data} = await sendWebNet(WebNetName.submit, {
            encryptedData: encrypt,
        }, {
            // isGet: false,
        });

        hideWaiting();

        if (!success) {
            // changeScene(HomeScene);
            showPanel(NoPrizePanel, {
                highest: score,
                score,
                isError: true,
            });

            return false;
        }

        const panelData = {
            prizeVO: data?.prizeVO,
            highest: data?.historyMaxScore || 0,
            score,
        }
        if (data?.prizeVO) {
            showPanel(PrizePanel, panelData);
        } else {
            showPanel(NoPrizePanel, panelData);
        }

    }

}
