import { _decorator, Button, Component, Node, Sprite, SpriteFrame } from 'cc';
import { AudioMgr } from "../../core_tgx/base/AudioMgr";

const {ccclass, property} = _decorator;

@ccclass('MusicBtn')
export class MusicBtn extends Component {

    @property(SpriteFrame) closeSf: SpriteFrame = null;
    @property(SpriteFrame) openSf: SpriteFrame = null;

    sp: Sprite = null;

    private _open: boolean = false;
    set open(open: boolean) {
        this._open = open;
        this.sp.spriteFrame = open ? this.openSf : this.closeSf;

        if (open) {
            AudioMgr.ins.resume();
        } else {
            AudioMgr.ins.pause();
        }
    }

    get open() {
        return this._open;
    }

    onLoad() {
        this.sp = this.getComponent(Sprite);
        this.node.on(Button.EventType.CLICK, this.clickNode, this);
    }

    start() {
        this.open = true;
    }

    clickNode() {
        this.open = !this.open;
    }
}


