import { _decorator, Component, Node } from 'cc';

const { ccclass, property } = _decorator;

@ccclass('GuideNode')
export class GuideNode extends Component {

    @property(Node)
    guideNode: Node[] = [];

    @property(Node)
    guide2Next: Node = null;

    @property(Node)
    guide3Next: Node = null;

    guideIndex: 0 | 1 | 2 | 3 | 4 = 0;

    get guideShow() {
        return this.node.active;
    }

    show(index: 1 | 2 | 3 | 4) {
        for (let i = 0; i < this.guideNode.length; i++) {
            if (this.guideNode[i]) {
                this.guideNode[i].active = false;
            }
        }

        this.node.active = true;
        if (this.guideNode[index - 1]) {
            this.guideNode[index - 1].active = true;
        }
        this.guideIndex = index;
    }

    hide() {
        this.node.active = false;
    }

    start() {
        this.hide();
    }

    update(deltaTime: number) {

    }
}


