import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite } from "cc";
import { changeScene, showPanel } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import { strFormat } from "../Utils/Utils";
import RankPanel from "./RankPanel";
import { mdEvent, popWindow } from "../AppTool";

const {ccclass, property} = _decorator;

@ccclass('PrizePanel')
export default class PrizePanel extends Panel {

    static bundle = "PrizePanel";
    static skin = "PrizePanel";
    // static group = "PrizePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) againBtn: Node = null;
    @property(Node) viewBtn: Node = null;
    @property(Node) rankBtn: Node = null;
    @property(Label) scoreLabel: Label = null;
    @property(Label) highestLabel: Label = null;


    @property(Label) prizeName: Label = null;

    @property(Sprite) img: Sprite = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.onClose, this);
        this.viewBtn.on(Button.EventType.CLICK, this.clickView, this);
        this.againBtn.on(Button.EventType.CLICK, this.clickAgain, this);
        this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
    }

    async start() {
        const {prizeVO, highest, score} = this.data;

        const {optionName, optionImg, rewardId} = prizeVO;

        mdEvent({
            pageView: "issueReward",
            additionalInfo: rewardId,
        });

        this.highestLabel.string = highest;
        this.scoreLabel.string = score;

        this.prizeName.string = strFormat(optionName, 20);
        this.img.spriteFrame = optionImg;
    }

    clickView = () => {
        // this.hidePanel();

        try {
            window["my"].postMessage({type: "goWallet"});
        } catch (e) {
            console.error(e);
        }
    }

    clickAgain = async () => {
        // this.hidePanel();
        popWindow();

        // const success = await GameMgr.ins.start();
        // if (!success) {
        //     changeScene(HomeScene);
        //     return;
        // }
        // changeScene(MainGame);
    }

    clickRank = () => {
        this.hidePanel();
        // changeScene(HomeScene);
        showPanel(RankPanel, {from: "Game"});
    }

    onClose = () => {
        // this.hidePanel();
        popWindow();
        changeScene(HomeScene);
    }

}
