import { _decorator, Component, Node, Sprite, SpriteFrame } from 'cc';

const {ccclass, property} = _decorator;

@ccclass('MusicBtn')
export class MusicBtn extends Component {

    @property(SpriteFrame) closeSf: SpriteFrame = null;
    @property(SpriteFrame) openSf: SpriteFrame = null;

    sp: Sprite = null;

    private _open: boolean = false;
    set open(open: boolean) {
        this._open = open;
        this.sp.spriteFrame = open ? this.openSf : this.closeSf;
    }

    get open() {
        return this._open;
    }

    onLoad() {
        this.sp = this.getComponent(Sprite);
    }

    start() {
        this.open = true;
    }
}


