import React, { useState } from "react";
import { Button } from "@src/components/Button";
import "./index.less";

// 转换为函数组件以正确使用Hooks
const ProductListModule = (props) => {
  const [curTab, setCurTab] = useState(1);
  const { curTabProductList = [], RATE_NAME = {} } = props;

  // 切换标签页
  const toggleTab = (tab) => {
    setCurTab(tab);
  };

  // 处理金额格式化
  const settleMoney = (money) => {
    // 这里应该实现金额格式化逻辑
    return money.toFixed(2);
  };

  // 跳转到详情页
  const jumpVirtualDetailHandle = (item) => {
    // 这里应该实现跳转逻辑
    console.log("跳转到产品详情:", item);
  };

  return (
    <div className="bottom_products">
      {curTab === 1 && <span className="tab1_bg"></span>}
      {curTab === 2 && <span className="tab2_bg"></span>}
      <span className="tab1_btn" onClick={() => toggleTab(1)}></span>
      <span className="tab2_btn" onClick={() => toggleTab(2)}></span>
      <div className="products_list">
        {curTabProductList.map((item, index) => (
          <div className="b_product_item" key={`r_prdct_${index}`}>
            <span className="b_product_name">{item.name}</span>
            {curTab === 2 ? (
              <>
                <div className="b_product_rate">
                  <span className="b_product_rate_value">{settleMoney(item.totalProfit || 0)}</span>
                  <span className="b_product_rate_label">累计收益</span>
                </div>
                <div className="b_product_shu">
                  <span className="b_product_shu_value">{settleMoney(item.positionMoney || 0)}</span>
                  <span className="b_product_shu_label">持仓金额</span>
                </div>
              </>
            ) : (
              <>
                <div className="b_product_rate">
                  {item.rate !== undefined && item.rate !== null && (
                    <span className="b_product_rate_value">{(item.rate / 100).toFixed(2)}%</span>
                  )}
                  <span className="b_product_rate_label">{RATE_NAME[item.type] || "年化收益率"}</span>
                </div>
                <div className="b_product_shu">
                  <span className="b_product_shu_value">{item.shenShuGuiZei}</span>
                  <span className="b_product_shu_label">
                    {item.fengXian} ｜ {item.qigouText}
                  </span>
                </div>
              </>
            )}
            <Button className="detail_btn_1" onClick={() => jumpVirtualDetailHandle(item)}></Button>
            <span className="b_product_line"></span>
          </div>
        ))}
      </div>
      {!curTabProductList.length && curTab === 2 && <div className="empty">暂无持仓产品哦</div>}
    </div>
  );
};

export default ProductListModule;
