"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./index.less";
import { Button } from "@src/components/Button";
import store from "@src/store";
import { PAGE_MAP } from "@src/utils/constants";
import { _throttle, dateFormatter } from "@src/utils/utils";
import API from "@src/api";

@observer
class Prizepage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      prizeList: [],
    };
  }
  async componentDidMount() {
    await this.getPrizeInfo();
  }

  getPrizeInfo = async () => {
    const { success, data } = await API.getPrizeList();
    if (success) {
      this.setState({
        prizeList: data || [],
      });
    }
  };

  goToLink = _throttle(async (item) => {
    const { id, url } = item;
    if (url) {
      location.href = url;
    } else {
      location.href = `/aaw/projectx/takePrize?projectOrderNo=${id}`;
    }
  });

  backHandle = () => {
    store.changePage(PAGE_MAP.ACTUAL_HOME_PAGE);
  };

  render() {
    const { prizeList } = this.state;
    return (
      <div className="prizepage">
        <div className="prize_list">
          {prizeList.length > 0 ? (
            prizeList.map((item, index) => (
              <div className="prize_item" key={index}>
                <span className="item_bg"></span>
                <span className="item_time">{dateFormatter(item.gmtCreate, "yyyy-MM-dd hh:mm:ss")}截止领取</span>
                <img className="item_img" src={item.extra?.icon}></img>
                <span className="item_name">{item.extra?.name}</span>
                {item.extra?.receiveStatus === 1 ? (
                  <div className="item_received">已领取</div>
                ) : (
                  <Button className="item_btn" onClick={() => this.goToLink(item)}></Button>
                )}
              </div>
            ))
          ) : (
            <div className="empty">
              <span className="empty_img"></span>
              <span className="empty_text">暂无奖品记录</span>
            </div>
          )}
        </div>
        <Button className="back" onClick={this.backHandle}></Button>
      </div>
    );
  }
}
export default Prizepage;
