'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import './positionpop.less';

@observer
class Positionpop extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      info:{}
    };
  }
  componentDidMount(){
    console.log(this.props);
    this.setState({
      info:this.props.item,
      infoList:[
        {
          productName:'华夏理财固收增强 最短持有120天A款A',
          profit:'17.72%',
          ratio:'35.50%',
        },
         {
          productName:'华夏理财固收增强 最短持有120天A款B',
          profit:'17.72%',
          ratio:'35.50%',
        },
         {
          productName:'华夏理财固收增强 最短持有120天A款C',
          profit:'17.72%',
          ratio:'35.50%',
        },
         {
          productName:'华夏理财固收增强 最短持有120天A款D',
          profit:'17.72%',
          ratio:'35.50%',
        },
         {
          productName:'华夏理财固收增强 最短持有120天A款E',
          profit:'17.72%',
          ratio:'35.50%',
        },

      ]
    })
  }
   clickClose = () => {
          ModalCtrl.closeModal();
      }
  render() {
    return (
      <div className="positionpop modal_center">
        <span className="iconbg"></span>
        <span className="iconclose" onClick={this.clickClose}></span>
        <span className="iconc"></span>
        <span className="icony"></span>
        <div className='info-list'>
            {/* <span className="iconbg1"></span> */}
            <span className="iconbg2"></span>
            <div className="info-list-title">
               <span className="chanPinMingCheng">产品名称</span>
               <span className="shouYiLu">收益率</span>
               <span className="chiCangZhanBi">持仓占比</span>
            </div>
            <div className="info-list-box">
              {
                this.state.infoList?.map((item, index) => (
                    <div key={index} className="list4">
                      <span className="productName">
                        {item.productName}
                      </span>
                      <span className="profit">{item.profit}</span>
                      <span className="ratio">{item.ratio}</span>
                    </div>
                ))
              }
              
            </div>
        </div>
       
        {/* <div className="list2">
          <span className="juXing7_2"></span>
          <span className="huaXiaLiCaiGuShouZengQiangZuiDuanChiYou120tianAkuanA_2">
            华夏理财固收增强 最短持有120天A款A
          </span>
          <span className="_1772_2">17.72%</span>
          <span className="_3550_2">35.50%</span>
        </div>
        <div className="list1">
          <span className="juXing7_3"></span>
          <span className="huaXiaLiCaiGuShouZengQiangZuiDuanChiYou120tianAkuanA_3">
            华夏理财固收增强 最短持有120天A款A
          </span>
          <span className="_1772_3">17.72%</span>
          <span className="_3550_3">35.50%</span>
        </div> */}
        <span className="name">{this.state.info.userName}</span>
        <span className="title">持仓情况</span>
        {/* <span className="icon1"></span> */}
      </div>
    );
  }
}
export default Positionpop;
