'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import API from '@/api';
import './positionpop.less';

@observer
class Positionpop extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      info:{},
      infoList:[]
    };
  }
  componentDidMount(){
    console.log(this.props);
    this.setState({
      info:this.props.item
    })
    this.getQueryDisperseInfo(this.props.item.type,this.props.item.userId);
  }
  getQueryDisperseInfo = async (type,userId) => {
    const {code, data, message, success} = await API.queryDisperseInfo({type,userId});
    if (success) {
      this.setState({
        infoList: data.holdInfo
      });
    }
  };
  clickClose = () => {
      ModalCtrl.closeModal();
  }
   // 格式化收益率，将原始值除以100
  formatProfit(profit) {
    const num = Number(profit);
    if (num == null) return 0;
    return (num / 100).toFixed(2);
  }
  render() {
    return (
      <div className="positionpop modal_center md12">
        <span className="iconbg"></span>
        <span className="iconclose" onClick={this.clickClose}></span>
        <span className="iconc"></span>
        <span className="icony"></span>
        <div className='info-list'>
            {/* <span className="iconbg1"></span> */}
            <span className="iconbg2"></span>
            <div className="info-list-title">
               <span className="chanPinMingCheng">产品名称</span>
               <span className="shouYiLu">收益率</span>
               <span className="chiCangZhanBi">持仓占比</span>
            </div>
            <div className="info-list-box">
              {
                this.state.infoList?.map((item, index) => (
                    <div key={index} className="list4">
                      <span className="productName">
                        {item.productName}
                      </span>
                      <span className="profit">{this.formatProfit(item.profit)}%</span>
                      <span className="ratio">{item.ratio}%</span>
                    </div>
                ))
              }
              
            </div>
        </div>
        <span className="name">{this.state.info.userName}</span>
        <span className="title">持仓情况</span>
        {/* <span className="icon1"></span> */}
      </div>
    );
  }
}
export default Positionpop;
