import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: 'projectRule.query',
  /** 获取前端配置项 */
  getFrontVariable: 'coop_frontVariable.query',

  // 首页
  index: "virtual/index.do",
  // 领取新手礼包
  receiveNewGift: "virtual/receiveNewGift.do",
  // 奖品记录
  records: "virtual/prizeRecords.do",
  // 查询签到数据
  querySign: "checkIn_1/querySign.do",
  // 完成签到
  doSign: "checkIn_1/doCheckIn.do",
  // 完成签到浏览任务
  completeSignView: "checkIn_1/completeSignView.do",
  // 交易记录页面
  tradeRecords: "virtual/tradeRecords.do",
  // 模拟理财获取记录
  queryWealthRecords: "userSpLogList.query",
  // 首页-产品参数更新
  coop_codeUpdate: {
    uri: "virtual/coop_codeUpdate.do",
    method: 'post',
    headers: {
      'Content-Type': 'application/json',
    },
  },
  // 产品首页信息
  productIndex: "product/index.do",
  // 产品赎回
  redeem: "product/redeem.do",
  // 产品买入
  buy: "product/buy.do",

   // 查看排行榜 
  queryRankInfo: "rank/queryRankInfo.do",
  // 查询分布信息
  queryDisperseInfo:"rank/queryDisperseInfo.do",
  // 理财成绩-领奖
  drawJoin: "draw/join.do",
  // 理财成绩-查询
  drawQuery: "draw/query.do",
  // 理财成绩-首页
  drawIndex: "draw/index.do",

  // 获取任务列表的接口
  getTaskList: "task_1/queryTasks.do",
  // 完成任务接口
  // completeTask: "task_1/doCompleted.do",
  completeTask: {
    uri: "task_1/doCompleted.do",
    method: 'post',
    withToken: true,
  },
  // 任务领奖接口
  // sendPrizeTask: "task_1/sendPrize.do",
  sendPrizeTask: {
    uri: "task_1/sendPrize.do",
    method: 'post',
    withToken: true,
  },
  // 查询题目
  queryQS: "answer_1/query.do",
  // 开始答题
  startQS: {
    uri: "answer_1/start.do",
    method: 'post',
    withToken: true,
  },
  // 获取题目
  getQS: {
    uri: "answer_1/getQuestion.do",
    method: 'post',
    withToken: true,
  },
  // 提交题目
  submitQS: {
    uri: "answer_1/submit.do",
    method: 'post',
    withToken: true,
  },
  // 完成答题
  completeQS: {
    uri: "answer_1/doCompleted.do",
    method: 'post',
    withToken: true,
  },


  // =============
  // getShareInfo: '/wechatShare/getShareInfo/v2',
  // getShareInfo: '/wechatMiniApp/ticket/info',
  // userLogin: {
  //   uri: "userLogin.check",
  //   showMsg: false,
  // },
  getInviteCode: {
    uri: 'inviteAssist_1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'inviteAssist_1/doAssist.do',
    withToken: true,
    method: 'post',
    showMsg: false,
  },
  /** 二维码 */
  // getQrcode: "/customActivity/qrcode/getQrcode",
  // 免登-华夏理财
  doAuth: {
    uri: "/customActivity/hxlc/login",
    method: 'post',
    headers: {
      'Content-Type': 'application/json',
    },
  },
  /** 分享落地页接口 */
  getSharePageInfo: "inviteAssist_1/coop_queryRecommand.do",

  doAsistInSharePage: {
    uri: "inviteAssist_1/coop_assist.do",
  },

  queryInviteCode: {
    uri: 'invite/queryInviteCode.do',
    withToken: true,
  }
})

export default API
