import API from '@/api';
import { makeAutoObservable } from 'mobx';
import store from './store';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import AnswerPanel from '@/panels/answerPanel';
import HomePage from '@/pages/HomePage/HomePage';
import { windowJumpUrl } from '@/utils/utils';
import { Toast } from '@grace/ui';
import shareStore from './share';
// import { handleTaskLogExposure } from '@/MD';
const taskStore = makeAutoObservable({
    // 任务列表
    taskInfo: {},
    taskList: [],
    setTaskInfo(data) {
        this.taskInfo = data || {};
    },
    async queryTaskInfo() {
        const { data, success } = await API.getTaskList({
            channel: CFG.channel
        });
        if (data && success) {
            this.setTaskInfo(data || {});
            const arr1 = data.item.filter((el) => { return Number(el.taskStatus) === 1; });
            const arr2 = data.item.filter((el) => { return Number(el.taskStatus) === 0; });
            const arr3 = data.item.filter((el) => { return Number(el.taskStatus) === 2; });
            this.taskList = arr1.concat(arr2, arr3);
            this.taskList.forEach(el => {
                const { code } = el;
                if (el.taskStatus == 0) {
                    // handleTaskLogExposure(16, code, 1);
                }
                if (el.taskStatus == 1) {
                    // handleTaskLogExposure(16, code, 2);
                }
            });
        }
    },

    // 完成任务
    completeInfo: {},
    setCompleteInfo(data) {
        this.completeInfo = data || {};
    },
    async doComplete(item) {
        if (!store.judgeActTime()) return;
        const { code, jumpUrl, extra, id } = item;
        if (code === 'invite') {
            // 邀请
            shareStore.doShare(true)
        }
        if (code === 'answer') {
            // 答题
            ModalCtrl.showModal(AnswerPanel)
        }
        if (code === 'fxcp') {
            // 风险测评
            this.completeTask(code)
            setTimeout(() => {
                windowJumpUrl(jumpUrl)
            }, 500)
        }
        if (code === 'csbj') {
            console.log("ssssss")
            // 花完初始本金
            ModalCtrl.closeModal()
            setTimeout(() => {
                store.homeRoot.scrollTop = 1800 * window.remScale;
            }, 300)

        }

    },
    // 完成任务
    async completeTask(code) {
        // const { success, data } = await API.completeTask({ channel: CFG.channel, code: code });
        const { success, data } = await API.completeTask({ taskCode: code });

        if (success) {
            await this.queryTaskInfo();
        }
    },

    // 领奖
    sendPrizeInfo: {},
    setSendPrizeInfo(data) {
        this.sendPrizeInfo = data || {};
    },
    async sendPrize(item) {
        console.log("🚀 ~ item:", item)
        // const { success, data } = await API.sendPrizeTask({ code: code, channel: CFG.channel });
        const { success, data } = await API.sendPrizeTask({ prizePendingCode: item.prizePendingCode, taskCode: item.code });
        if (success) {
            store.updateIndex();
            taskStore.queryTaskInfo();
            Toast.show("领取成功~")
        } else {
            this.sendPrizeInfo = {};
        }
    },
});

export default taskStore;
