'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";

@observer
class SignTaskPop extends React.Component {
  constructor(props) {
    super(props);
  }

  handleToLink = _asyncThrottle(async () => {
    if(this.props.callback) {
      await this.props.callback();
    }
    setTimeout(() => {
      ModalCtrl.closeModal();
    }, 300)
    location.href = this.props.otherPrizeInfo?.link || ''
  })

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  render() {
    const {otherPrizeInfo} = this.props;
    return (
      <div className="signTaskPop modal_center">
        <div className='center-box'>
          <span className="bg"></span>
          <div className='prize_remark'>浏览“{otherPrizeInfo?.productName}”产品，再得{otherPrizeInfo?.prizeName}</div>
          <img className="prize_img" src={otherPrizeInfo?.prizeImg || ''} alt="" />
          <Button className="know_btn md18" onClick={this.handleToLink} />
          {/* <Button className="close" onClick={this.handleClose} /> */}
        </div>
      </div>
    );
  }
}
export default SignTaskPop;
