/** ========== 华夏银行APP 华夏理财APP 端内方法 start =========== */

import { isIos } from "@/AppTools";

// 判断jsbridge加载完成
function ready(callback) {
    if (window.AlipayJSBridge) {
        callback && callback();
    } else {
        document.addEventListener("AlipayJSBridgeReady", callback, false);
    }
}

function bfSearchMenu(param, callback) {
    window.AlipayJSBridge.call('BFSearchMenuHandler', {
        param: param,
    }, callback)
}

/** 行方跳转方法-华夏银行 */
export function appJump(url) {
    console.info("bfSearchMenu url", url)
    // 判断端内，若在端内走回调
    ready(() => {
        // 跳转的路径，视具体修改
        bfSearchMenu({
            url
        })
    })
}


/** 跳转行方页面-华夏理财 */
export function hxlcAppJump(fundcode) {
    const navBarStyle = { 'backgroundColor': '#d20a10' }
    const target = "gmu://web?startPage=" +
        encodeURIComponent(
            `index.html#/fund-detail?fundcode=${fundcode}&from=third`
        ) +
        `&navBarType=2&navBarStyle=${encodeURIComponent(JSON.stringify(navBarStyle))}`
    console.info('目标地址=================>：', target);
    window.location.href = target
}

/** 
 * 分享方法
*/
export function hxbankShare(shareInfo) {
    console.info('shareInfo----', shareInfo);
    // | 参数 | 是否必传 | 参数说明 |
    // | :----: | :----: | :----: | 
    // | title | 否 | 分享内容 |
    // | content | 否 | 分享内容 |
    // | linkUrl | 否 | 分享跳转 |
    // | imgData | 否 | 分享的图片 |
    // | showType | 否 | 分享类型，为空时，显示 微信好友、朋友圈、保存长途、复制链接， 还支持 2、3、4、6几种类型 |
    // | callback | 否 | 回调函数， 用于接收分享回到 |
    var params = {
        title: shareInfo.title,
        content: shareInfo.content,
        linkUrl: shareInfo.url,
        showType: "2,3"
    };
    window.hxbExtLib.hxbShare(params, (e) => {
        console.info("hxbShare---------------", e);
        if (e.type == '2') {
            if (e.result == '0') {
                setTimeout(e => {
                    screenShots(e => {
                        if (e.result == '1') {
                            console.log({ content: '保存图片成功' });
                        }
                    })
                }, 100)
            }
        } else if (e.type == '3' && e.result == '1') {
            console.log({ content: '复制成功' });
        }
    });
}

/** ========== 华夏银行APP 华夏理财APP 端内方法 end =========== */




/** ========== 其他三方合作APP端内方法 start =========== */

/** 
 * 行方跳转方法-渤海
 * 比如提供的链接为：
 *    20200602:/www/finaProductDetail.html?reqParam=%7B%22prdCode%22%3A%2223112004C%22%2C%22prdType%22%3A%2214%22%7D
 * 最终的参数：
 *    url = /www/finaProductDetail.html
 *    appId = 20200602
 *    needLogin = N
 *    Type = B
 *    params = {"prdCode":"23112004C","prdType":"14"}
 * 具体规则：
 *    appId 就是冒号前面的一串数字
 *    url 就是冒号后面 问号前面的一串字符串
 *    params 就是regParam=之后的一串 进行解码
 */
export function boHaiAppJump(jumpUrl) {
    // 通过链接处理为对应参数
    const arr1 = jumpUrl.split(':')
    console.info('boHaiAppJump arr1===', arr1)
    const appId = arr1?.[0]
    const arr2 = arr1?.[1].split('?reqParam=')
    console.info('boHaiAppJump arr2===', arr2)
    const url = arr2?.[0]
    const params = arr2?.[1] ? JSON.parse(decodeURIComponent(arr2[1])) : ''
    const data = {
        url,
        appId, //离线包id		string类型。离线包id
        needLogin: 'N', // 是否需要登录	Y	string类型。Y:需要登录 N:不需要登录
        type: 'B', // 跳转类型	Y	string类型。B：离线包 T：三方链接
        params, //离线包所需参数		json格式
    }
    console.info('boHaiAppJump data===', data)
    const param = JSON.stringify(data)
    if (isIos()) {
        window.webkit.messageHandlers.jumpOfflineApp.postMessage(param);
    } else {
        window.NavJSPlugin.jumpOfflineApp(param);
    }
}

/** ========== 其他三方合作APP端内方法 end =========== */
