'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import { CircleTurntable } from "@spark/circle-turntable";
import './index.less';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import store from "@/store/store";
import API from "@/api";
import { NoPrizePanel } from "@/panels/NoPrizePanel/NoPrizePanel.tsx";
import { PrizePanel } from "@/panels/PrizePanel/PrizePanel.tsx";

@observer
class SetupSuccessPop extends React.Component {
  turntableRef = null; // 大转盘
  btnStarting = false; // 转盘是否启动
  drawResultInfo = {};
  constructor(props) {
    super(props);
  }

  async componentDidMount() {
  }

  onStop = async() => {
    this.btnStarting = false;
    store.updateIndex();
    if (this.drawResultInfo.prizeId == "thanks") {
      ModalCtrl.showModal(NoPrizePanel, {type: 'final_turntable', ...this.drawResultInfo});
    } else {
      ModalCtrl.showModal(PrizePanel, {type: 'final_turntable', ...this.drawResultInfo});
    }
    ModalCtrl.closeModal(SetupSuccessPop);
  }

  // 开始抽奖
  drawHandle = _asyncThrottle(async () => {
    if (this.btnStarting) return false;

    this.btnStarting = true;

    const { success, data } = await API.receiveNewGift();
    if (!success) {
        this.btnStarting = false;
        return;
    }
    this.drawResultInfo = data;

    this.turntableRef.launch();
    const index = store.indexData?.giftPop?.actPrizeVO?.findIndex((item) => item.prizeId === this.drawResultInfo.prizeId);
    if(index != -1) {
      this.turntableRef.braking(index);
    }
  });

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal();
  })

  render() {
    const { giftPop } = store.indexData || {};

    return (
      <div className="setupSuccessPop modal_center">
        <span className="bg"></span>
        <div className='turnTable_box'>
          <CircleTurntable
            className="tt_box"
            // @ts-ignore
            ref={(ref) => (this.turntableRef = ref)}
            options={giftPop?.actPrizeVO || []}
            angleOffset={180 / 6 + 10} // 角度偏移量
            radian={78} // 奖项半径
            launchDuration={1000} // 启动时间
            // 大转盘背景
            renderBackground={<div className="turntable_bg"></div>}
            // 大转盘指针
            renderStartButton={<div className="ttBtn"/>}
            // 渲染奖品信息
            renderOption={(option) => {
              return <div className="prize_item">
                <div className="prize_name">{option.prizeName}</div>
                <img className="prize_img" src={option.prizeImg} alt=""/>
              </div>;
            }}
            didStop={this.onStop}
          />
        </div>
        <Button className="know_btn md3" onClick={this.drawHandle}/>
        <Button className="close" onClick={this.handleClose} />
      </div>
    );
  }
}
export default SetupSuccessPop;
