'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { _throttle } from '@/utils/utils';
import { Button } from '@grace/ui';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { dateFormatter } from "@/utils/utils.ts";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import API from '@/api';


@observer
class NewRecordPage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      list: [],
      tab: props?.tab || 1
    }
    this.pageNum = 1;
    this.pageSize = 20;
    this.haveMore = true;
    this.API = this.props.tab === 1 ? API.tradeRecords : API.queryWealthRecords;
  }
  clickBack = () => {
    PageCtrl.changePage(HomePage);
  }
  componentDidMount() {
    this.updateList();
  }


  async updateList() {
    const { pageNum, pageSize, haveMore } = this;
    if (!haveMore) return;
    const { success, data } = await this.API({ pageNum, pageSize, spId: 'sp_wealth' });
    if (!success) return;
    this.pageNum++;
    this.haveMore = data.haveMore;
    const list = this.state.list.concat(data.list);
    this.setState({ list })
  }

  handleScroll = (e) => {
    if (e.target.scrollHeight - e.target.scrollTop <= e.target.clientHeight) {
      this.updateList();
    }
  }

  tabChange(tab) {
    this.setState({
      tab: tab,
      list: []
    })
    this.pageNum = 1;
    this.pageSize = 20;
    this.haveMore = true;
    this.API = tab === 1 ? API.tradeRecords : API.queryWealthRecords;
    this.updateList();
  }
  render() {
    const { list, tab } = this.state;
    return (
      <div className="newRecordPage">
        <span className="bg"></span>
        <span className='bg-lachang'></span>
        <Button className="backBtn" onClick={this.clickBack} />
        <div className={`tab-con tab-${this.state.tab}`}>
          <div className='tab-btn-1' onClick={_throttle(() => {
            this.tabChange(1)
          })}></div>
          <div className='tab-btn-2' onClick={_throttle(() => {
            this.tabChange(2)
          })}></div>
        </div>
        <div>
          {list?.length
            ? <div className="list" onScroll={this.handleScroll}>
              {
                tab === 1 && list.map((item, index) => {

                  const state = {
                    0: { txt: "购买待确认", color: "rgba(0,0,0,0.6)" },
                    1: { txt: "购买成功", color: "#ee4e32" },
                    2: { txt: "赎回成功", color: "#1b8a4f" },
                    3: { txt: "购买失败", color: "rgba(0,0,0,0.6)" },
                  }[item.tradeStatus];

                  return <div className="item" key={index}>
                    <div className="title">{item.desc}</div>
                    <div
                      className="date">{dateFormatter(item.gmtCreate, "yyyy.MM.dd hh:mm:ss")}</div>
                    <div className="num">¥{item.amount / 100}</div>
                    {/*<div className={styles.num}>¥0000000.00</div>*/}
                    <div className="state" style={{ color: state.color }}>{state.txt}</div>
                  </div>
                })
              }
              {
                tab === 2 && list.map((item, index) => {
                  return <div className="item" key={index}>
                    <div className="title">{item.extra}</div>
                    <div
                      className="date">{dateFormatter(item.createTimestamp, "yyyy.MM.dd hh:mm:ss")}</div>
                    <div className="num" style={{ color: 'rgba(0,0,0,1)' }}>{`${item.changedType}¥${item.quantity}`}</div>
                  </div>
                })
              }
            </div>
            : <div className="listNone">暂无交易记录哦</div>
          }
        </div>
      </div>
    );
  }
}
export default NewRecordPage;
