'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './rulepop.less';
import store from '../../store/store';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";

@observer
class Rulepop extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {
    if (!store.ruleInfo) {
      store.initRule()
    }
  }

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  render() {
    return (
      <div className="rulepop modal_center">
        <span className="bg"></span>
        <div className="text" dangerouslySetInnerHTML={{ __html: store.ruleInfo }}></div>
        <Button className="close" onClick={this.handleClose} />
      </div>
    );
  }
}
export default Rulepop;
