import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: 'projectRule.query',
  /** 获取前端配置项 */
  getFrontVariable: 'coop_frontVariable.query',

  // 首页
  index: "real/index.do",
  // 报名
  signIn: "real/signIn.do",
  // 领取新手礼包
  receiveNewGift: "real/receiveNewGift.do",
  // 奖品记录
  records: "real/prizeRecords.do",
  // 查询签到数据
  querySign: "checkIn_1/querySign.do",
  // 完成签到
  doSign: "checkIn_1/doCheckIn.do",
  // 完成签到浏览任务
  completeSignView: "checkIn_1/completeSignView.do",
  // 产品首页信息
  productIndex: "product/index.do",
  // 产品赎回
  redeem: "product/redeem.do",
  // 产品买入
  buy: "product/buy.do",
  // 查看排行榜 
  queryRankInfo: "rank/queryRankInfo.do",
  // 查询分布信息
  queryDisperseInfo:"rank/queryDisperseInfo.do",
  // 理财成绩-领奖
  drawJoin: "draw/join.do",
  // 理财成绩-查询
  drawQuery: "draw/query.do",
  // 理财成绩-首页
  drawIndex: "draw/index.do",



  // =============
  // getShareInfo: '/wechatShare/getShareInfo/v2',
  getShareInfo: '/wechatMiniApp/ticket/info',
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },
  getInviteCode: {
    uri: 'inviteAssist_1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'inviteAssist_1/doAssist.do',
    withToken: true,
    method: 'post',
    showMsg: false,
  },
  /** 二维码 */
  getQrcode: "/customActivity/qrcode/getQrcode",
  // 免登-华夏理财
  doAuth: {
    uri: "/customActivity/hxlc/login",
    method: 'post',
    headers: {
      'Content-Type': 'application/json',
    },
  },
  /** 分享落地页接口 */
  getSharePageInfo: "invite/coop_queryRecommand.do",
  doAsistInSharePage: {
    uri: "invite/coop_assist.do",
  },
  queryInviteCode: {
    uri: 'invite/queryInviteCode.do',
    withToken: true,
  }
})

export default API
