'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import store from '../../store/store';
import { Button } from '@grace/ui';
import { _asyncThrottle, _throttle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { handleTaskLogClick } from '@/MD';

import API from '@/api';
import taskStore from '@/store/task';

@observer
class TaskPanel extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      taskList: []
    }
  }
  componentDidMount() {
    taskStore.queryTaskInfo();
  }
  // getTaskList = _asyncThrottle(async () => {
  //   const { success, data } = await API.getTaskList();
  //   if (success) {
  //     this.setState({
  //       taskList: data.item || []
  //     })
  //   }
  // })
  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })


  render() {
    const { taskList } = taskStore;
    return (
      <div className="taskPanel modal_center">
        <span className="bg">
          <div className='taskList'>
            {
              taskList.map((el, index) => {
                return <div className='taskItem' key={index}>
                  <img src={el.icon} className='taskIcon' />
                  <span className='taskTitle'>{`${el.title}（${el.completedSize || 0}/${el.intervalLimitSize || 0}）`}</span>
                  <span className='taskSubTitle'>{el.subtitle}</span>
                  {el.taskStatus == 0 && <Button className='goToBtn' onClick={_asyncThrottle(() => {
                    handleTaskLogClick(16, el.code, 1);
                    taskStore.doComplete(el)
                  })}></Button>}
                  {el.taskStatus == 1 && <Button className='dailingqu' onClick={_asyncThrottle(() => {
                    handleTaskLogClick(16, el.code, 2);
                    taskStore.sendPrize(el);
                  })}></Button>}
                  {el.taskStatus == 2 && <Button className='completed'></Button>}
                </div>
              })
            }
          </div>
          <Button className="close" onClick={this.handleClose} />
        </span>

      </div>
    );
  }
}
export default TaskPanel;
