'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import { _asyncThrottle, dateFormatter, formatThousand } from '@/utils/utils';
import { Button, Toast } from "@grace/ui";
import API from '@/api';
import './myqradespage.less';

@observer
class Myqradespage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
        monthInfo:[],   // 月份信息
        selectIndex: 0,
        selectId: {},
        info:{}
    };
  }
  componentDidMount() {
    this.getMonthInfo();
  }
  // 获取月份信息
  getMonthInfo = async () => {
    const {code, data, message, success} = await API.drawQuery();
    if (success) {
      this.setState({
        monthInfo: data.monthInfo
      });
      this.getdrawIndex(data.monthInfo[0].monthId);
    }
  }
  // 获取理财成绩-首页
  getdrawIndex = async (monthId) => {
    const {code, data, message, success} = await API.drawIndex({monthId});
    if (success) {
      this.setState({
        info: data
      });
    }
  }
  // 格式化分转换为元并添加千分位分隔符
  formatMoney = (amount) => {
    return formatThousand((amount / 100).toFixed(2))
  }
  // 返回
  clickBack = _asyncThrottle(() => {
    PageCtrl.changePage(HomePage);
  })
  // 点击查看
  clickView = _asyncThrottle(() => {
    const {url, recordId } = this.state.info.prizeInfo || {};
    if(url){
        location.href = url
    }else {
        location.href = `/aaw/projectx/takePrize?projectOrderNo=${recordId}`
    }
  })
  // 点击月份
  clickMonth = _asyncThrottle((item, index) => {
    console.log("🚀 ~ Myqradespage ~ item, index:", item, index)
    this.setState({
      selectIndex: index,
      selectId: item.monthId,
    })
    this.getdrawIndex(item.monthId)
  })
  // 点击立即领取
  clickClaim = _asyncThrottle(() => {
    const { selectId } = this.state;
    console.log("🚀 ~ Myqradespage ~ selectId:", selectId)
    this.getdrawJoin(selectId);
    // Toast.show("领取成功");
  })
  // 领取奖品
  getdrawJoin = async (monthId) => {
    const {code, data, message, success} = await API.drawJoin({monthId});
    if (success) {
      Toast.show("领取成功");
      this.getdrawIndex(monthId);
    }
  }
  render() {
    const { monthInfo, selectIndex } = this.state;
    return (
      <div className="myqradespage">
        <span className="bg"></span>
        <span className="back" onClick={() => this.clickBack()}></span>
        {
          this.state.info?.drawStatus != 1 ? (
            <div className="lottery">
              <span className="icon3">
                <img src={this.state.info.prizeInfo?.prizeImg} alt="" />
              </span>
              <span className="jiangPinMingCheng">{this.state.info.prizeInfo?.prizeName}</span>
              {
                this.state.info.drawStatus == 0 && (
                  <span className="btn1 md13" onClick={() => this.clickClaim()}></span>
                )
              }
              {
                this.state.info.drawStatus == 2 && (
                  <span className="btn2" onClick={() => this.clickView()}></span>
                )
              }
            </div>
          ) : (
            <div className="lottery2">
            </div>
          )
        }
      
       
        <div className="ranking">
          <span className="rankingbg"></span>
          <div className="badge">
              <span className="xxx">{this.state.info.rank == null ? '未上榜' : this.state.info.rank > 100 ? '99+' : this.state.info.rank}</span>
           
          </div>
          <div className="ranking1">
            <span className="woDeShouYiLuPaiMing">我的收益率排名</span>
            <span className="diXxx">{this.state.info.rank == null ? '未上榜' : this.state.info.rank > 100 ? '第99+' : '第' + this.state.info.rank}</span>
          </div>
          <div className="ranking2">
            <span className="juXing880"></span>
            <span className="liCaiZiJin">理财资金</span>
            <span className="_334556675yuan">{this.formatMoney(this.state.info.totalAmount)}元</span>
          </div>
          <div className="ranking3">
            <span className="juXing880_1"></span>
            <span className="leiJiShouYi">累计收益</span>
            <span className="_2213yuan">{this.formatMoney(this.state.info.totalProfit)}元</span>
          </div>
          <div className="ranking4">
            <span className="juXing880_2"></span>
            <span className="liCaiZhouQi">收益率</span>
            <span className="_2025062220250722">{this.state.info.profitRatio}%</span>
          </div>
        </div>
        <span className="woDeChengJi">我的成绩</span>
        <div className="month">
          {
            monthInfo.map((item, index) => (
              <div className="yue" key={item.monthId} onClick={() => this.clickMonth(item,index)}>
                    {
                      selectIndex === index && (
                      <span className="line"></span>
                      )
                    }
                    
                    {
                      item.receiveStatus == 0 && (
                        <span className="icon1"></span>
                      )
                    }
                    {item.monthId.split('-')[1] + '月'}
                 </div>
            ))
          }
         
        </div>
      </div>
    );
  }
}
export default Myqradespage;