import React from "react";
import { observer } from "mobx-react";
import { Button } from "@src/components/Button";
import SignModule from "@src/pages/components/SignModule";
import RankModule from "@src/pages/components/RankModule";
import BannerModule from "@src/pages/components/BannerModule";
import ProductListModule from "@src/pages/components/ProductListModule";
import "./index.less";
import modalStore from "@src/store/modal";
import { _throttle } from "@src/utils/utils";
import store from "@src/store/index";
import { PAGE_MAP } from "@src/utils/constants";

@observer
class ActualHome extends React.Component {
  componentDidMount() {
    // modalStore.pushPop("rulePop");
  }

  // 打开规则弹窗
  openRule = _throttle(() => {
    modalStore.pushPop("rulePop");
  });

  // 跳转我的奖品
  goPrize = _throttle(() => {
    store.changePage(PAGE_MAP.PRIZE_PAGE);
  });

  render() {
    return (
      <div className="com_Container">
        <div className="actual-home-page">
          {/* 规格&奖品 */}
          <Button className="rule-icon" onClick={this.openRule}></Button>
          <Button className="prize-icon" onClick={this.goPrize}></Button>

          {/* 其他icon */}
          <Button className="new-user-gift-icon"></Button>
          <Button className="finance-achievement-icon"></Button>

          {/* 排行榜 */}
          <RankModule />

          {/* 真实持仓 */}

          {/* banner区 */}
          <BannerModule />

          {/* 签到 */}
          <SignModule />

          {/* 产品列表 */}
          <ProductListModule />

          <div style={{ height: "90px" }}></div>
        </div>
      </div>
    );
  }
}

export default ActualHome;
