/** 渠道 */
export const CHANNEL = {
  /** 华夏理财 */
  HXLC: "1",
  /** 母行-华夏银行 */
  HXBANK: "2",
  /** 渠道5-昆仑银行 */
  KUNLUN: "5",
};

/**
 * 普通跳转客服
 * 注意:小程序需要额外增加业务域名 https://duiba.qiyukf.com/
 */
export function jumpService() {
  location.href = location.origin + "/faq/index";
}

/** 跳转行方页面-华夏理财 */
export function hxlcAppJump(fundcode) {
  const navBarStyle = { backgroundColor: "#d20a10" };
  const target =
    // eslint-disable-next-line @spark/best-practices/no-url-in-js
    "gmu://web?startPage=" +
    encodeURIComponent(`index.html#/fund-detail?fundcode=${fundcode}&from=third`) +
    `&navBarType=2&navBarStyle=${encodeURIComponent(JSON.stringify(navBarStyle))}`;
  console.info("目标地址=================>：", target);
  window.location.href = target;
}

// 判断jsbridge加载完成
function ready(callback) {
  if (window.AlipayJSBridge) {
    callback && callback();
  } else {
    document.addEventListener("AlipayJSBridgeReady", callback, false);
  }
}

function bfSearchMenu(param, callback) {
  window.AlipayJSBridge.call(
    "BFSearchMenuHandler",
    {
      param: param,
    },
    callback
  );
}

/** 行方跳转方法-华夏银行 */
export function appJump(url) {
  console.info("bfSearchMenu url", url);
  // 判断端内，若在端内走回调
  ready(() => {
    // 跳转的路径，视具体修改
    bfSearchMenu({
      url,
    });
  });
}

/** 跳转方法 区分app */
export function diffJump(url) {
  if (CFG.channel == CHANNEL.HXLC) {
    // 华夏理财
    hxlcAppJump(url);
  } else if (CFG.channel == CHANNEL.HXBANK) {
    // 华夏银行
    appJump(url);
  } else {
    // 其他三方app
    location.href = url;
  }
}
