import React, { Component } from 'react'
import { observer } from "mobx-react";
import { createRoot } from "react-dom/client";
import store from "./store/store";

import "./core/checkwebp.ts";
import "./MD";
import './App.less'
import '@csstools/normalize.css';

import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import { GetCurrSkinId, getCustomShareId } from "@/utils/utils.ts";

import HomePage from "@/pages/HomePage/HomePage.tsx";
import Auth from "@/pages/auth/auth.jsx";

import PrizePage from "@/pages/PrizePage/PrizePage.tsx";
import SharePage from "@/pages/sharePage/sharePage.jsx";


@observer
class App extends Component {

  showDefaultPage = () => {
    const skinId = GetCurrSkinId() || getCustomShareId();
    const defaultPage = {
      auth: Auth, // TODO 举例子 新宿台奖品页
      index: HomePage,
      prize: PrizePage,
      share: SharePage
    }[skinId] || HomePage;
    PageCtrl.changePage(defaultPage);
  }

  async componentDidMount() {
    this.showDefaultPage();

    await store.getFrontVariable();
    // store.initShare()
  }

  componentWillUnmount() {

  }

  render() {
    return <>
      <PageCtrl />
      <ModalCtrl />
    </>;
  }
}

const root = createRoot(document.getElementById('root')!);
root.render(
  <App />
);

