import { Component } from "react";

import "./PrizePanel.less";
import { Button } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { _throttle } from "@/utils/utils";

export class PrizePanel extends Component<any, any> {

    componentDidMount() {
    }

    clickClose = () => {
        ModalCtrl.closeModal();
    }

    clickBtn = _throttle(() => {
        const { type } = this.props;
        ModalCtrl.closeModal();
    })

    render() {

        const { optionImg, optionName, type } = this.props;

        return <div className="PrizePanel modal_center">
            <div className="bg" />
            <img className="img" src={optionImg} />
            <div className="prizeName">{optionName}</div>
            <Button className={`btn`} onClick={this.clickBtn} />
            <div className="tips">奖品可在【首页】-【我的奖品】中查看</div>
            <Button className="close" onClick={this.clickClose} />
        </div>
    }


}
