'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";

@observer
class SignSuccessPop extends React.Component {
  constructor(props) {
    super(props);
  }

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  render() {
    const {prizeInfo} = this.props;
    return (
      <div className="signSuccessPop modal_center">
        <div className='center-box'>
          <span className="bg"></span>
          <div className='prize_title'>恭喜获得{prizeInfo?.optionName}</div>
          <div className='prize_name'>{prizeInfo?.optionName}</div>
          <Button className="know_btn md11" onClick={this.handleClose} />
          <Button className="close" onClick={this.handleClose} />
        </div>
      </div>
    );
  }
}
export default SignSuccessPop;
