import React from 'react';
import { observer } from 'mobx-react';
import styles from './PrizePage.module.less';
import { Button } from "@grace/ui";
import classNames from "classnames";
import resStore from "@/store/ResStore.ts";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import { dateFormatter, getUrlParam } from "@/utils/utils.ts";

@observer
class PrizePage extends React.Component<any, any> {
    async componentDidMount() {
        resStore.updatePrizeList();
    }

    clickBack = () => {
        PageCtrl.changePage(HomePage);
    }

    clickItem = (item) => {
        if (item.url) {
            location.href = item.url
        } else {
            location.href = `/aaw/projectx/takePrize?projectOrderNo=${item.id}`
        }
    }

    render() {
        const { prizeList } = resStore;

        return <div className={styles.PrizePage}>
            <div className={styles.bg}></div>
            {
                prizeList?.length
                    ? <div className={styles.prizeList}>
                        {prizeList?.map((item, index) => {
                            return <div className={styles.prizeItem}>
                                <img className={styles.itemImg} src={item.extra.icon}/>
                                <div className={styles.itemName}>{item.extra.name}</div>
                                <div
                                    className={styles.itemDate}>{dateFormatter(item.gmtCreate, "yyyy-MM-dd hh:mm:ss 获得")}</div>
                                {
                                    item.extra.receiveStatus == 1
                                        ? <Button className={styles.itemBtnEd} onClick={() => this.clickItem(item)}/>
                                        : <Button className={styles.itemBtn} onClick={() => this.clickItem(item)}/>
                                }

                            </div>
                        })}
                    </div>
                    : <div className={styles.listNone}></div>
            }
            {/* {getUrlParam("off") != "1" && <Button className={styles.backBtn} onClick={this.clickBack}/>} */}
            <Button className={styles.backBtn} onClick={this.clickBack}/>
        </div>;
    }
}

export default PrizePage;
