'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { Toast } from '@grace/ui';
import API from '@/api';
import store from '@/store/store';

@observer
class SetupPop extends React.Component {
  constructor(props) {
    super(props);
  }

  async componentDidMount() {
  }

  handleSetup = _asyncThrottle(async () => {
    try {
      await API.signIn()
      await store.updateIndex();
      Toast.show('报名成功');
      ModalCtrl.closeModal(SetupPop);
    } catch (error) {
      Toast.show(error.message || '报名失败');
    }
  })

  // handleClose = _asyncThrottle(() => {
  //   ModalCtrl.closeModal();
  // })

  render() {
    return (
      <div className="setupPop modal_center">
        <span className="bg"></span>
        <Button className="know_btn md2" onClick={this.handleSetup} />
        {/* <Button className="close" onClick={this.handleClose} /> */}
      </div>
    );
  }
}
export default SetupPop;
