'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import { _asyncThrottle, dateFormatter, formatThousand } from '@/utils/utils';
import { Button, Toast } from "@grace/ui";
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import {PrizePanel} from "@/panels/PrizePanel/PrizePanel.tsx"
import {NoPrizePanel} from "@/panels/NoPrizePanel/NoPrizePanel.tsx"
import API from '@/api';
import './myqradespage.less';

@observer
class Myqradespage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
        info:{}
    };
  }
  componentDidMount() {
     this.getdrawIndex();
  }
  // 获取理财成绩-首页
  getdrawIndex = async () => {
    const {code, data, message, success} = await API.drawIndex({});
    if (success) {
      this.setState({
        info: data
      });
    }
  }
   // 格式化分转换为元并添加千分位分隔符
  formatMoney = (amount) => {
    return formatThousand((amount / 100).toFixed(2))
  }

  // 返回
  clickBack = () => {
    PageCtrl.changePage(HomePage);
  }
  // 点击立即领取
  clickClaim = _asyncThrottle(() => {
    this.getdrawJoin();
    // Toast.show("领取成功");
  })
  // 领取奖品
  getdrawJoin = async () => {
    const {code, data, message, success} = await API.drawJoin({});
    if (success) {
      if(data.prizeId == 'thanks'){
        ModalCtrl.showModal(NoPrizePanel);
      }
      else{
        ModalCtrl.showModal(PrizePanel,
          {
            optionImg: data.optionImg,
            optionName: data.optionName,
          }
        );
      }
      this.getdrawIndex();
    }
  }
  // 立即查看
  clickView = () => {
    const {url, recordId} = this.state.info.prizeInfo;
    if(url){
      location.href = url
    }else {
      location.href = `/aaw/projectx/takePrize?projectOrderNo=${recordId}`
    }
  }
  render() {
    return (
      <div className="myqradespage">
        <span className="bg"></span>
        <span className="back" onClick={() => this.clickBack()}></span>
        {
           this.state.info.drawStatus == 1 && (
            <>
              <div className="lottery"></div>
              <span className="icon3"></span>
              <span className="btn1 md20" onClick={() => this.clickClaim()}></span>
            </>
          )
        }
        {
           this.state.info.drawStatus == 2 && (
            <>
               <div className="lottery"></div>
               <img className='prize-img' src={this.state.info.prizeInfo.prizeImg} alt="" />
               <div className='prize-name'>{this.state.info.prizeInfo.prizeName}</div>
              <span className="btn2" onClick={() => this.clickView()}></span>
            </>
          )
        }
        <div className="ranking">
          <span className="rankingbg"></span>
          <div className="badge">
               <span className="xxx">{this.state.info.rank == null ? '未上榜' : this.state.info.rank >= 100 ? '99+' : this.state.info.rank}</span>
           
          </div>
          <div className="ranking1">
            <span className="woDeShouYiLuPaiMing">我的收益率排名</span>
            <span className="diXxx">{this.state.info.rank == null ? '未上榜' : this.state.info.rank >= 100 ? '第99+' : '第' + this.state.info.rank}</span>
          </div>
          <div className="ranking2">
            <span className="juXing880"></span>
            <span className="liCaiZiJin">理财资金</span>
            <span className="_334556675yuan">{this.formatMoney(this.state.info.amount)}元</span>
          </div>
          <div className="ranking3">
            <span className="juXing880_1"></span>
            <span className="leiJiShouYi">累计收益</span>
            <span className="_2213yuan">{this.formatMoney(this.state.info.profit)}元</span>
          </div>
          <div className="ranking4">
            <span className="juXing880_2"></span>
            <span className="liCaiZhouQi">理财周期</span>
            <span className="_2025062220250722">{dateFormatter(this.state.info.cycleStartTime, 'yyyy.MM.dd')}-{dateFormatter(this.state.info.cycleEndTime, 'yyyy.MM.dd')}</span>
          </div>
        </div>
        <span className="woDeChengJi">我的成绩</span>
      </div>
    );
  }
}
export default Myqradespage;
