import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { GameEvent, globalEvent } from "@/pages/GamePage/GameEvent.ts";

export class Level5 extends LevelBase {

  level: number = 5;

  A: Sprite;
  B: Sprite;
  C: Sprite;
  D: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(447, 669);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(143, 999);

    this.D = this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)));
    this.D.position.set(377, 999);

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(201, 775);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.position.set(371, 993);
    this.right.alpha = 0;
    this.right.interactive = false;

    this.error = this.addChild(new Sprite(Assets.get(`common/error.png`)));
    this.error.visible = false;
    this.error.interactive = false;

    [this.A, this.B, this.C, this.D]
      .forEach((item) => {
        item.on("pointertap", this.onTapOption.bind(this, item));
      });

    this.A.on("pointerdown", this.onAPointerDown, this);
    this.A.on("pointerup", this.onAPointerUp, this);
    this.A.on("globalpointermove", this.onAPointerMove, this);
  }

  onTapOption(item: Sprite) {
    this.pos = null;

    this.setTouchEnable(false);

    const dp = new Map([
      [this.A, { x: 70, y: 70 }],
      [this.B, { x: 120, y: 190 }],
      [this.C, { x: 10, y: 140 }],
      [this.D, { x: 150, y: 150 }],
    ]).get(item);
    this.error.position.set(item.x + dp.x, item.y + dp.y);

    this.error.visible = true;
    Tween.removeTweens(this.error);
    Tween.get(this.error)
      .wait(2000)
      .call(() => {
        this.error.visible = false;
        this.setTouchEnable(true);
      });
  }

  pos = null;

  onAPointerUp(e) {
    this.pos = null;
  }

  onAPointerDown(e) {
    const { x, y } = e.data.global;
    this.pos = {
      x: x - this.A.x,
      y: y - this.A.y
    }
  }

  onAPointerMove(e) {
    if (!this.pos) return;
    const { x, y } = e.data.global;
    const nx = x - this.pos.x;
    const ny = y - this.pos.y;
    this.A.position.set(nx, ny);

    if (
      nx >= 400
      && nx <= 500
      && ny >= 1000
      && ny <= 1120
    ) {
      this.setPauseCd(true);
      this.setTouchEnable(false);
      Tween.get(this.A)
        .to({ x: 439, y: 1073 }, 444, Ease.quadInOut)
        .call(() => {
          Tween.get(this.right)
            .to({ alpha: 1 }, 444, Ease.quadInOut)
            .wait(2000)
            .call(() => {
              globalEvent.emit(GameEvent.NextLevel);
            });
        })

    }
  }

  onDestroy() {
    super.onDestroy();
    Tween.removeTweens(this.A);
    Tween.removeTweens(this.error);
    Tween.removeTweens(this.right);
    this.A.off("globalpointermove", this.onAPointerMove, this);
  }

}
