"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./settlechance.less";
import { Button, Toast } from "@grace/ui";
import { _asyncThrottle } from "../../utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { SvgaPlayer } from "@grace/svgaplayer";

import lightSvga from "../../assets/svga/6输出弹窗.svga";
import Capsulepage from "../../pages/CapsulePage/CapsulePage";
@observer
class Settlechance extends React.Component {
  constructor(props) {
    super(props);
  }
  
  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  handleKnow = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  handleDraw = _asyncThrottle(() => {
    ModalCtrl.closeModal()
    PageCtrl.changePage(Capsulepage)
  })



  render() {
    const { data } = this.props || {};
    const {
      drawChance = 0,
      title = "",
      desc = "",
      img = "",
      score = 0,
    } = data || {};
    return (
      <div className="settlechance modal_center">
        <SvgaPlayer className="light" src={lightSvga} />
        <span className="bg"></span>
        <Button className="draw md19" onClick={this.handleDraw} />
        <Button className="know md17" onClick={this.handleKnow} />
        <img className="icon" 
          src = {img}
          alt = {title}
        />
        <span className="ribbon"></span>
        <span className="title">恭喜您, 答对{score}题</span>
        <span className="tip1">获得了「{title}」称号</span>
        <span className="tip2">{desc}</span>
        <span className="tip3">恭喜获得抽奖机会+{drawChance}</span>
        <Button className="close md18" onClick={this.handleClose} />
      </div>
    );
  }
}
export default Settlechance;
