import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";
import { Assets, Sprite } from "pixi.js";

export class Level4 extends LevelBase {

  level: number = 4;

  A: Sprite;
  B: Sprite;
  C: Sprite;
  D: Sprite;

  right: Sprite;
  error: Sprite;

  onLoad() {
    super.onLoad();

    this.A = this.addChild(new Sprite(Assets.get(`level${this.level}/A.png`)));
    this.A.position.set(73, 1061);

    this.B = this.addChild(new Sprite(Assets.get(`level${this.level}/B.png`)));
    this.B.position.set(296, 1061);

    this.C = this.addChild(new Sprite(Assets.get(`level${this.level}/C.png`)));
    this.C.position.set(519, 1061);

    this.D = this.addChild(new Sprite(Assets.get(`level${this.level}/D.png`)));
    this.D.position.set(269, 668);

    this.right = this.addChild(new Sprite(Assets.get(`level${this.level}/right.png`)));
    this.right.position.set(243, 658);
    this.right.visible = false;
    this.right.interactive = false;

    this.error = this.addChild(new Sprite(Assets.get(`level${this.level}/error.png`)));
    this.error.visible = false;
    this.error.interactive = false;

    [this.A, this.B, this.C, this.D]
      .forEach((item) => {
        item.on("pointertap", this.onTapOption.bind(this, item));
      });

  }

  onTapOption(item: Sprite) {
    const isRight = item === this.D;
    this.right.visible = isRight;
    this.error.visible = !isRight;

    const dp = -7;
    this.error.position.set(item.x + dp, item.y + dp);

  }

}
