import { Assets, PointData, Sprite, Ticker } from "pixi.js";
import 'pixi.js/math-extras';
import { Base } from "@/core/pixi/base/Base.ts";
import { observer, reactor } from "./mobx/decorators.ts";
import { GameEvent, globalEvent } from "./GameEvent.ts";
import { Level1 } from "@/pages/GamePage/Level/Level1.ts";
import { Level2 } from "@/pages/GamePage/Level/Level2.ts";
import { Level3 } from "@/pages/GamePage/Level/Level3.ts";
import { Level4 } from "@/pages/GamePage/Level/Level4.ts";
import { Level5 } from "@/pages/GamePage/Level/Level5.ts";
import { Level7 } from "@/pages/GamePage/Level/Level7.ts";
import { Level8 } from "@/pages/GamePage/Level/Level8.ts";
import { Level9 } from "@/pages/GamePage/Level/Level9.ts";
import { Level14 } from "@/pages/GamePage/Level/Level14.ts";
import { Level23 } from "@/pages/GamePage/Level/Level23.ts";
import gameStore from "@/store/gameStore.ts";
import { LevelArr } from "@/pages/GamePage/Level/LevelConfig.ts";
import { LevelBase } from "@/pages/GamePage/Components/LevelBase.ts";

@observer
export class Game extends Base {

  level: LevelBase = null;

  onLoad() {
    const qsBg = this.addChild(new Sprite(Assets.get("问题.png")));
    qsBg.position.set(49, 316);

    this.level = this.addChild(new Level9());

    gameStore.start();

    globalEvent.on(GameEvent.NextLevel, this.nextLevel, this);

    // this.nextLevel();

  }

  nextLevel() {

    gameStore.gameInfo.levelIndex++;

    const { levelIndex, levelIdxArr } = gameStore.gameInfo;

    if (levelIndex >= levelIdxArr.length) {
      return;
    }

    const levelIdx = levelIdxArr[levelIndex];

    if (this.level) {
      this.level.removeFromParent();
      this.level.destroy();
    }

    const cls = LevelArr[levelIdx];

    this.level = this.addChild(new cls());
  }

  receiveEffect(point: PointData) {

  }

  onUpdate(time: Ticker) {
    // const dt = time.deltaMS / 1000;
  }

  onDestroy() {
  }
}
